"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.PaginateSwaggerTransaction = exports.PaginatePublicationBusiness = exports.PaginateSwaggerBusiness = exports.PaginateSwagger = void 0;
const swagger_1 = require("@nestjs/swagger");
const class_validator_1 = require("class-validator");
const class_transformer_1 = require("class-transformer");
const messages_validator_1 = require("../validator/messages-validator");
class PaginateSwagger {
}
exports.PaginateSwagger = PaginateSwagger;
__decorate([
    (0, class_transformer_1.Type)(() => Number),
    (0, class_validator_1.IsOptional)(),
    (0, class_validator_1.Min)(1, { message: messages_validator_1.Message.min }),
    (0, class_validator_1.IsNumber)({}, { message: messages_validator_1.Message.isNumber }),
    (0, swagger_1.ApiProperty)({ type: Number, required: false, description: "Numero de pagina", default: 1 }),
    __metadata("design:type", Number)
], PaginateSwagger.prototype, "page", void 0);
__decorate([
    (0, class_transformer_1.Type)(() => Number),
    (0, class_validator_1.IsOptional)(),
    (0, class_validator_1.Min)(1, { message: messages_validator_1.Message.min }),
    (0, class_validator_1.IsNumber)({}, { message: messages_validator_1.Message.isNumber }),
    (0, swagger_1.ApiProperty)({ type: Number, required: false, description: "Cantidad de registros por pagina", default: 10 }),
    __metadata("design:type", Number)
], PaginateSwagger.prototype, "limit", void 0);
__decorate([
    (0, class_validator_1.IsOptional)(),
    (0, class_validator_1.IsString)({ message: messages_validator_1.Message.isString }),
    (0, swagger_1.ApiProperty)({ type: String, required: false, description: "Texto a buscar" }),
    __metadata("design:type", String)
], PaginateSwagger.prototype, "search", void 0);
class PaginateSwaggerBusiness extends PaginateSwagger {
}
exports.PaginateSwaggerBusiness = PaginateSwaggerBusiness;
__decorate([
    (0, class_validator_1.IsOptional)(),
    (0, class_transformer_1.Type)(() => Number),
    (0, class_validator_1.Min)(1, { message: messages_validator_1.Message.min }),
    (0, class_validator_1.IsNumber)({}, { message: messages_validator_1.Message.isNumber }),
    (0, swagger_1.ApiProperty)({ type: Number, required: false, description: "state", default: 1 }),
    __metadata("design:type", Number)
], PaginateSwaggerBusiness.prototype, "state", void 0);
__decorate([
    (0, class_validator_1.IsOptional)(),
    (0, swagger_1.ApiProperty)({ type: String, required: false, description: "tipo", default: "hotel" }),
    __metadata("design:type", String)
], PaginateSwaggerBusiness.prototype, "type", void 0);
__decorate([
    (0, class_validator_1.IsOptional)(),
    (0, swagger_1.ApiProperty)({ type: String, required: false, description: "vertical", default: "vistas" }),
    __metadata("design:type", String)
], PaginateSwaggerBusiness.prototype, "vertical", void 0);
class PaginatePublicationBusiness extends PaginateSwagger {
}
exports.PaginatePublicationBusiness = PaginatePublicationBusiness;
__decorate([
    (0, class_validator_1.IsOptional)(),
    (0, class_transformer_1.Type)(() => Number),
    (0, class_validator_1.Min)(1, { message: messages_validator_1.Message.min }),
    (0, class_validator_1.IsNumber)({}, { message: messages_validator_1.Message.isNumber }),
    (0, swagger_1.ApiProperty)({ type: Number, required: false, description: "id", default: 1 }),
    __metadata("design:type", Number)
], PaginatePublicationBusiness.prototype, "id", void 0);
__decorate([
    (0, class_validator_1.IsOptional)(),
    (0, class_transformer_1.Type)(() => Number),
    (0, class_validator_1.Min)(1, { message: messages_validator_1.Message.min }),
    (0, class_validator_1.IsNumber)({}, { message: messages_validator_1.Message.isNumber }),
    (0, swagger_1.ApiProperty)({ type: Number, required: false, description: "state", default: 1 }),
    __metadata("design:type", Number)
], PaginatePublicationBusiness.prototype, "state", void 0);
class PaginateSwaggerTransaction extends PaginateSwagger {
}
exports.PaginateSwaggerTransaction = PaginateSwaggerTransaction;
__decorate([
    (0, class_validator_1.IsOptional)(),
    (0, swagger_1.ApiProperty)({ type: String, required: false, description: "tipo", default: 1 }),
    __metadata("design:type", String)
], PaginateSwaggerTransaction.prototype, "type", void 0);
//# sourceMappingURL=query-paginate.js.map