"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.CsvService = void 0;
const common_1 = require("@nestjs/common");
const csv = require("csv-parser");
const stream_1 = require("stream");
const ExcelJS = require("exceljs");
const fs = require("fs");
const path = require("path");
let CsvService = class CsvService {
    async parseCsvBuffer(buffer) {
        const results = [];
        return new Promise((resolve, reject) => {
            const stream = stream_1.Readable.from(buffer.toString("utf-8"));
            stream
                .pipe(csv())
                .on('data', (data) => results.push(data))
                .on('end', () => {
                resolve(results);
            })
                .on('error', (error) => {
                reject(error);
            });
        });
    }
    async readExcel(buffer) {
        const workbook = new ExcelJS.Workbook();
        await workbook.xlsx.load(buffer);
        const worksheet = workbook.getWorksheet(1);
        const jsonData = [];
        const headers = worksheet.getRow(1).values.slice(1);
        worksheet.eachRow((row, rowNumber) => {
            if (rowNumber === 1)
                return;
            const rowData = {};
            row.values.slice(1).forEach((value, index) => {
                rowData[headers[index]] = `${value?.text ?? value}`;
            });
            jsonData.push(rowData);
        });
        return jsonData;
    }
    async saveExcelFromJson(data, filename) {
        const workbook = new ExcelJS.Workbook();
        const worksheet = workbook.addWorksheet('Datos');
        if (data.length > 0) {
            const headers = Object.keys(data[0]);
            worksheet.columns = headers.map(header => ({
                header: header.charAt(0).toUpperCase() + header.slice(1),
                key: header,
                width: 20,
            }));
        }
        data.forEach(item => {
            worksheet.addRow(item);
        });
        const filePath = path.join(__dirname, '..', 'uploads', filename);
        const dirPath = path.dirname(filePath);
        if (!fs.existsSync(dirPath)) {
            fs.mkdirSync(dirPath, { recursive: true });
        }
        await workbook.xlsx.writeFile(filePath);
        console.log(`Archivo guardado en: ${filePath}`);
    }
};
exports.CsvService = CsvService;
exports.CsvService = CsvService = __decorate([
    (0, common_1.Injectable)()
], CsvService);
//# sourceMappingURL=csv.service.js.map