"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.JWT_CONFIG = exports.DB_CONFIG = void 0;
const typeorm_naming_strategies_1 = require("typeorm-naming-strategies");
require('dotenv').config();
const DB_CONFIG = {
    type: 'postgres',
    host: process.env.DB_HOST,
    port: +process.env.DB_PORT,
    username: process.env.DB_USER,
    password: process.env.DB_PASSWORD,
    database: process.env.DB_NAME,
    schema: process.env.DB_SCHEMA,
    autoLoadEntities: true,
    synchronize: process.env.DB_SYNCHRONIZE === 'true',
    dropSchema: process.env.DB_DROP_SCHEMA === 'true',
    namingStrategy: new typeorm_naming_strategies_1.SnakeNamingStrategy(),
    ssl: { rejectUnauthorized: false }
};
exports.DB_CONFIG = DB_CONFIG;
const JWT_CONFIG = {
    secret: process.env.JWT_KEY,
    signOptions: { expiresIn: process.env.JWT_EXPIRED },
    global: true
};
exports.JWT_CONFIG = JWT_CONFIG;
//# sourceMappingURL=config-database.js.map