"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.StateService = void 0;
const common_1 = require("@nestjs/common");
const typeorm_1 = require("@nestjs/typeorm");
const state_entity_1 = require("../../entity/state.entity");
const sucre_1 = require("../../util/arcgis/sucre");
const csv_service_1 = require("../../util/csv.service");
const cocha_json_1 = require("../../util/tripadvisor/cocha.json");
const typeorm_2 = require("typeorm");
let StateService = class StateService {
    constructor(stateEntity, excelService) {
        this.stateEntity = stateEntity;
        this.excelService = excelService;
    }
    async all() {
        let ads = {
            banner: "ca-app-pub-5859541306379589/6663876697",
            native: "ca-app-pub-1446919414404001/1181686975",
            intersticial: 'ca-app-pub-5859541306379589/8653062433',
            banner_active: "S",
            native_active: "S",
            intersticial_active: "S",
        };
        let states = await this.stateEntity.find();
        return { ads, states };
    }
    async getById(idState) {
        let state = await this.stateEntity.findOne({ where: { id: idState } });
        return state;
    }
    async parseInfoPedidosYa(data) {
        let result = data.data.map(x => {
            return {
                NOMBRE: x.name,
                DETALLE: "",
                LATITUD: x.address.latitude,
                LONGITUD: x.address.longitude,
                DIRECCION: x.address.street,
                DEPARTAMENTO: 3,
                TIPO_NEGOCIO: [...x.business.types].join(","),
                LOGO: x.logo_url,
                PORTADA: x.header_url,
                WEB: "",
                TELEFONO: ""
            };
        });
        await this.excelService.saveExcelFromJson(result, `${new Date().getTime()}.xlsx`);
        return result;
    }
    async getAllTour() {
        let publishedData = sucre_1.sucre.props.publishedData.nodes;
        let resources = sucre_1.sucre.props.publishedData.resources;
        let allPlaces = publishedData["n-PtEkpW"].data.places;
        let allRefLocation = publishedData["n-NlIAuT"].data.geometries;
        let server = "https://cdn.arcgis.com/sharing/rest/content/items/" + sucre_1.sucre.query.id + "/resources/";
        let excel = [];
        allPlaces = allPlaces.map(x => {
            x["location"] = allRefLocation[x.featureId].nodes[0];
            console.log(x.title);
            x["title"] = publishedData[x.title].data.text;
            x["detail"] = publishedData[x.contents[0]].data.text;
            console.log(publishedData[x.media].children[0]);
            x["image"] = server + resources[publishedData[publishedData[x.media].children[0]].data.image]?.data?.resourceId;
            excel.push({
                NOMBRE: x.title,
                DETALLE: x["detail"],
                LATITUD: x["location"].lat,
                LONGITUD: x["location"].long,
                DIRECCION: "",
                DEPARTAMENTO: 11,
                TIPO_NEGOCIO: [8].join(","),
                LOGO: x["image"],
                PORTADA: x["image"],
                WEB: "",
                TELEFONO: ""
            });
            return x;
        });
        await this.excelService.saveExcelFromJson(excel, `tour-sucre.xlsx`);
        return { allPlaces, count: allPlaces.length };
    }
    async getTripAdvisor() {
        let filter = cocha_json_1.cochaTripAdvisor.map(x => {
            return {
                NOMBRE: x.name,
                DETALLE: "",
                LATITUD: x.location.geoPoint.latitude,
                LONGITUD: x.location.geoPoint.longitude,
                DIRECCION: x.taLocation.contact.streetAddress.fullAddress,
                DEPARTAMENTO: 6,
                TIPO_NEGOCIO: [2].join(","),
                LOGO: `${x.thumbnail?.photo.photoSizeDynamic.urlTemplate}`.replace("{width}", "400").replace("{height}", "400"),
                PORTADA: `${x.thumbnail?.photo.photoSizeDynamic.urlTemplate}`.replace("{width}", "600").replace("{height}", "400"),
                WEB: x.menu.menuUrl,
                TELEFONO: x.taLocation.contact?.telephone
            };
        });
        await this.excelService.saveExcelFromJson(filter, `rest-cocha.xlsx`);
        return filter;
    }
};
exports.StateService = StateService;
exports.StateService = StateService = __decorate([
    (0, common_1.Injectable)(),
    __param(0, (0, typeorm_1.InjectRepository)(state_entity_1.StateEntity)),
    __metadata("design:paramtypes", [typeorm_2.Repository,
        csv_service_1.CsvService])
], StateService);
//# sourceMappingURL=state.service.js.map