import { StateEntity } from 'src/entity/state.entity';
import { CsvService } from 'src/util/csv.service';
import { Repository } from 'typeorm';
export declare class StateService {
    private stateEntity;
    private excelService;
    constructor(stateEntity: Repository<StateEntity>, excelService: CsvService);
    all(): Promise<{
        ads: {
            banner: string;
            native: string;
            intersticial: string;
            banner_active: string;
            native_active: string;
            intersticial_active: string;
        };
        states: StateEntity[];
    }>;
    getById(idState: number): Promise<StateEntity>;
    parseInfoPedidosYa(data: any): Promise<any>;
    getAllTour(): Promise<{
        allPlaces: {
            id: string;
            featureId: string;
            contents: string[];
            media: string;
            title: string;
        }[];
        count: number;
    }>;
    getTripAdvisor(): Promise<{
        NOMBRE: string;
        DETALLE: string;
        LATITUD: number;
        LONGITUD: number;
        DIRECCION: string;
        DEPARTAMENTO: number;
        TIPO_NEGOCIO: string;
        LOGO: string;
        PORTADA: string;
        WEB: string;
        TELEFONO: string;
    }[]>;
}
