"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.StateController = void 0;
const common_1 = require("@nestjs/common");
const auth_guard_1 = require("../../middleware/auth.guard");
const state_service_1 = require("./state.service");
const swagger_1 = require("@nestjs/swagger");
let StateController = class StateController {
    constructor(stateService) {
        this.stateService = stateService;
    }
    async all() {
        let rows = await this.stateService.all();
        return {
            statusCode: 200,
            message: ["OK"],
            data: rows
        };
    }
    async alltour() {
        let rows = await this.stateService.getAllTour();
        return {
            statusCode: 200,
            message: ["OK"],
            data: rows
        };
    }
    async getTripAdvisor() {
        let rows = await this.stateService.getTripAdvisor();
        return {
            statusCode: 200,
            message: ["OK"],
            data: rows
        };
    }
    parseDataPedidosYa(data) {
        return this.stateService.parseInfoPedidosYa(data);
    }
};
exports.StateController = StateController;
__decorate([
    (0, common_1.Get)(),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", Promise)
], StateController.prototype, "all", null);
__decorate([
    (0, common_1.Get)('tour'),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", Promise)
], StateController.prototype, "alltour", null);
__decorate([
    (0, common_1.Get)('tripadvisor'),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", Promise)
], StateController.prototype, "getTripAdvisor", null);
__decorate([
    (0, common_1.Post)('parse'),
    __param(0, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object]),
    __metadata("design:returntype", void 0)
], StateController.prototype, "parseDataPedidosYa", null);
exports.StateController = StateController = __decorate([
    (0, common_1.Controller)('state'),
    (0, auth_guard_1.Public)(),
    (0, swagger_1.ApiTags)("Lista departamentos"),
    __metadata("design:paramtypes", [state_service_1.StateService])
], StateController);
//# sourceMappingURL=state.controller.js.map