"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.ReviewService = void 0;
const common_1 = require("@nestjs/common");
const typeorm_1 = require("@nestjs/typeorm");
const review_entity_1 = require("../../entity/review.entity");
const typeorm_2 = require("typeorm");
const publication_entity_1 = require("../../entity/publication.entity");
let ReviewService = class ReviewService {
    constructor(reviewEntity, publicationEntity) {
        this.reviewEntity = reviewEntity;
        this.publicationEntity = publicationEntity;
    }
    async create(data, user) {
        let publication = await this.publicationEntity.findOne({ where: { id: data.publicationId }, select: { id: true } });
        common_1.Logger.log(`**************************** **************`);
        console.log(publication);
        if (!publication)
            throw new common_1.NotFoundException("La publicacion no existe");
        let review = await this.reviewEntity.save({
            publication: publication,
            createdAt: new Date(),
            detail: data.comment,
            user: { id: user.id }
        });
        common_1.Logger.log(`**************************** **************`);
        console.log(review);
        return review;
    }
};
exports.ReviewService = ReviewService;
exports.ReviewService = ReviewService = __decorate([
    (0, common_1.Injectable)(),
    __param(0, (0, typeorm_1.InjectRepository)(review_entity_1.ReviewEntity)),
    __param(1, (0, typeorm_1.InjectRepository)(publication_entity_1.PublicationEntity)),
    __metadata("design:paramtypes", [typeorm_2.Repository,
        typeorm_2.Repository])
], ReviewService);
//# sourceMappingURL=review.service.js.map