import { ReviewEntity } from 'src/entity/review.entity';
import { Repository } from 'typeorm';
import { CreateReviewDTO } from './dto/review-create.dto';
import { PublicationEntity } from 'src/entity/publication.entity';
import { UserEntity } from 'src/entity/user.entity';
export declare class ReviewService {
    private reviewEntity;
    private publicationEntity;
    constructor(reviewEntity: Repository<ReviewEntity>, publicationEntity: Repository<PublicationEntity>);
    create(data: CreateReviewDTO, user: UserEntity): Promise<{
        publication: PublicationEntity;
        createdAt: Date;
        detail: string;
        user: {
            id: number;
        };
    } & ReviewEntity>;
}
