"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.PublicationService = void 0;
const common_1 = require("@nestjs/common");
const typeorm_1 = require("@nestjs/typeorm");
const event_entity_1 = require("../../entity/event.entity");
const publication_entity_1 = require("../../entity/publication.entity");
const review_entity_1 = require("../../entity/review.entity");
const typeorm_2 = require("typeorm");
let PublicationService = class PublicationService {
    constructor(publicationEntity, reviewEntity, eventEntity) {
        this.publicationEntity = publicationEntity;
        this.reviewEntity = reviewEntity;
        this.eventEntity = eventEntity;
    }
    async all() {
    }
    async getByBusiness(query) {
        let like = query.search ? `%${query.search}%` : "";
        let limit = query.limit || 10;
        let page = ((query.page || 1) - 1) * limit;
        let queryBuilder = this.publicationEntity.createQueryBuilder('publication')
            .leftJoinAndSelect('publication.business', 'b')
            .loadRelationCountAndMap('publication.comments', 'publication.reviews', 'rv')
            .select([
            'publication.id',
            'publication.title',
            'publication.image',
            'publication.createdAt',
            'publication.detail',
            'b.id',
            'b.name',
            'b.logo'
        ])
            .orderBy("publication.id", "DESC");
        if (query.id) {
            queryBuilder.where("publication.id_negocio =:business", { business: query.id });
        }
        if (query.state) {
            queryBuilder.where("b.id_departamento =:state", { state: query.state });
        }
        let [result, count] = await queryBuilder
            .take(limit)
            .skip(page)
            .getManyAndCount();
        return {
            data: result,
            total: count,
            page: query.page,
            totalPages: Math.ceil(count / limit)
        };
    }
    async getByBusinessMap(query) {
        let like = query.search ? `%${query.search}%` : "";
        let limit = query.limit || 10;
        let page = ((query.page || 1) - 1) * limit;
        let queryBuilder = this.publicationEntity.createQueryBuilder('publication')
            .leftJoinAndSelect('publication.business', 'b')
            .select([
            'publication.id',
            'b.id',
            'b.name',
            'b.address',
            'b.logo'
        ])
            .orderBy("publication.id", "DESC");
        if (query.id) {
            queryBuilder.where("publication.id_negocio =:business", { business: query.id });
        }
        if (query.state) {
            queryBuilder.where("b.id_departamento =:state", { state: query.state });
        }
        let [result, count] = await queryBuilder
            .take(limit)
            .skip(page)
            .getManyAndCount();
        return {
            data: result,
            total: count,
            page: query.page,
            totalPages: Math.ceil(count / limit)
        };
    }
    async getEvents(query) {
        let like = query.search ? `%${query.search}%` : "";
        let limit = query.limit || 10;
        let page = ((query.page || 1) - 1) * limit;
        let queryBuilder = this.eventEntity.createQueryBuilder('event')
            .orderBy("event.id", "DESC");
        if (query.id) {
            queryBuilder.where("event.id_negocio =:business", { business: query.id });
        }
        if (query.state) {
            queryBuilder.where("event.id_departamento =:state", { state: query.state });
        }
        let [result, count] = await queryBuilder
            .take(limit)
            .skip(page)
            .getManyAndCount();
        return {
            data: result,
            total: count,
            page: query.page,
            totalPages: Math.ceil(count / limit)
        };
    }
    async getComments(query) {
        let like = query.search ? `%${query.search}%` : "";
        let limit = query.limit || 10;
        let page = ((query.page || 1) - 1) * limit;
        let queryBuilder = this.reviewEntity.createQueryBuilder('review')
            .leftJoinAndSelect('review.user', 'u')
            .select([
            'review',
            'u.id',
            'u.name',
            'u.lastName',
            'u.profile'
        ])
            .where("review.id_publicacion =:publication", { publication: query.id })
            .orderBy("review.id", "DESC");
        let [result, count] = await queryBuilder
            .take(limit)
            .skip(page)
            .getManyAndCount();
        return {
            data: result,
            total: count,
            page: query.page,
            totalPages: Math.ceil(count / limit)
        };
    }
};
exports.PublicationService = PublicationService;
exports.PublicationService = PublicationService = __decorate([
    (0, common_1.Injectable)(),
    __param(0, (0, typeorm_1.InjectRepository)(publication_entity_1.PublicationEntity)),
    __param(1, (0, typeorm_1.InjectRepository)(review_entity_1.ReviewEntity)),
    __param(2, (0, typeorm_1.InjectRepository)(event_entity_1.EventEntity)),
    __metadata("design:paramtypes", [typeorm_2.Repository,
        typeorm_2.Repository,
        typeorm_2.Repository])
], PublicationService);
//# sourceMappingURL=publication.service.js.map