import { EventEntity } from 'src/entity/event.entity';
import { PublicationEntity } from 'src/entity/publication.entity';
import { ReviewEntity } from 'src/entity/review.entity';
import { PaginatePublicationBusiness } from 'src/util/paginate/query-paginate';
import { Repository } from 'typeorm';
export declare class PublicationService {
    private publicationEntity;
    private reviewEntity;
    private eventEntity;
    constructor(publicationEntity: Repository<PublicationEntity>, reviewEntity: Repository<ReviewEntity>, eventEntity: Repository<EventEntity>);
    all(): Promise<void>;
    getByBusiness(query: PaginatePublicationBusiness): Promise<{
        data: PublicationEntity[];
        total: number;
        page: number;
        totalPages: number;
    }>;
    getByBusinessMap(query: PaginatePublicationBusiness): Promise<{
        data: PublicationEntity[];
        total: number;
        page: number;
        totalPages: number;
    }>;
    getEvents(query: PaginatePublicationBusiness): Promise<{
        data: EventEntity[];
        total: number;
        page: number;
        totalPages: number;
    }>;
    getComments(query: PaginatePublicationBusiness): Promise<{
        data: ReviewEntity[];
        total: number;
        page: number;
        totalPages: number;
    }>;
}
