"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.MicroService = void 0;
const axios_1 = require("@nestjs/axios");
const common_1 = require("@nestjs/common");
const typeorm_1 = require("@nestjs/typeorm");
const rxjs_1 = require("rxjs");
const business_entity_1 = require("../../entity/business.entity");
const micro_entity_1 = require("../../entity/micro.entity");
const typeorm_2 = require("typeorm");
const moment = require("moment-timezone");
const routes_1 = require("./data/routes");
let MicroService = class MicroService {
    constructor(microEntity, httpService, businessEntity) {
        this.microEntity = microEntity;
        this.httpService = httpService;
        this.businessEntity = businessEntity;
        this.routeApiURL = "http://localhost:8080/otp/routers/default/plan";
        this.route = routes_1.routes;
    }
    async getRouteById(id) {
        const ruta = this.route.geojson.features.find(x => x.properties.id == id);
        if (!ruta)
            throw new common_1.HttpException("Ruta no encontrada", common_1.HttpStatus.NOT_FOUND);
        let lineString = ruta.geometry.coordinates.map(([longitude, latitude]) => `${longitude} ${latitude}`).join(',');
        lineString = `LINESTRING(${lineString})`;
        const business = await this.businessEntity.createQueryBuilder('business')
            .where(`
                ST_DWithin(
                    ST_Transform(ST_SetSRID(ST_MakePoint(business.longitud, business.latitud), 4326), 3857),
                    ST_Transform(ST_GeomFromText(:line, 4326), 3857),
                    :radius
                )
                `, {
            line: lineString,
            radius: 100,
        }).getMany();
        return {
            coordinates: ruta.geometry.coordinates,
            line: ruta.properties.operator,
            name: ruta.properties.name,
            business: business.map(x => ({
                id: x.id,
                name: x.name,
                address: x.address,
                latitud: x.latitud,
                longitud: x.longitud,
                logo: x.logo,
            }))
        };
    }
    async routes(file, data) {
        let content = file.buffer.toString('utf8');
        let route = [];
        content.split("\n").forEach(x => {
            let coordinates = x.split(",");
            if (coordinates.length > 2) {
                route.push({
                    longitude: coordinates[0].trim(),
                    latitude: coordinates[1]
                });
            }
        });
        if (route[0].latitude != route[1].latitude) {
        }
        await this.microEntity.save({
            fin: data.fin,
            inicio: data.inicio,
            imagen: data.imagen,
            linea: data.linea,
            ruta: btoa(JSON.stringify(route)),
            state: data.state
        });
        return { line: data.linea, route: btoa(JSON.stringify(route)) };
    }
    async getAll(query) {
        let like = query.search ? `%${query.search}%` : "";
        let limit = query.limit || 10;
        let page = ((query.page || 1) - 1) * limit;
        const queryBuilder2 = this.microEntity.createQueryBuilder('micro')
            .select(["micro.id", "micro.linea", "micro.inicio", "micro.fin"])
            .where("state_id =:state", { state: query.state })
            .orderBy("micro.id", "DESC");
        let [result, count] = await queryBuilder2
            .getManyAndCount();
        return {
            data: result,
            total: count,
            page: query.page,
            totalPages: Math.ceil(count / limit)
        };
    }
    async plan(start, end) {
        const bolivianTime = moment.tz('America/La_Paz');
        const mapRoute = {};
        const time = bolivianTime.format('HH:mm');
        const date = bolivianTime.format('MM-DD-YYYY');
        try {
            const params = {
                fromPlace: start,
                toPlace: end,
                time,
                date,
                mode: 'TRANSIT,WALK,CAR',
                arriveBy: false,
                wheelchair: false,
                showIntermediateStops: false,
                debugItineraryFilter: "LIST_ALL",
                umItineraries: 5,
                searchWindow: 5,
                timetableView: true,
                additionalParameters: "numItineraries,searchWindow,timetableView",
                locale: 'es',
            };
            const { data } = await (0, rxjs_1.firstValueFrom)(this.httpService.get(this.routeApiURL, { params }));
            let response = data;
            const routes = [];
            response.plan.itineraries.forEach(element => {
                let keyRoute = element.legs.map(x => x.route.replaceAll(" ", "_")).filter(x => x != "").join("_");
                keyRoute = (keyRoute == "" ? "walk" : keyRoute);
                if (!mapRoute[keyRoute])
                    routes.push(element);
                mapRoute[keyRoute] = keyRoute;
            });
            console.log(mapRoute);
            response.plan.itineraries = routes;
            return { data: response.plan };
        }
        catch (error) {
            common_1.Logger.log(`**************************** error**************`);
            console.log(error);
            throw new common_1.HttpException(`Error al obtener la ruta: ${error.message}`, common_1.HttpStatus.BAD_REQUEST);
        }
    }
};
exports.MicroService = MicroService;
exports.MicroService = MicroService = __decorate([
    (0, common_1.Injectable)(),
    __param(0, (0, typeorm_1.InjectRepository)(micro_entity_1.MicroEntity)),
    __param(2, (0, typeorm_1.InjectRepository)(business_entity_1.BusinessEntity)),
    __metadata("design:paramtypes", [typeorm_2.Repository,
        axios_1.HttpService,
        typeorm_2.Repository])
], MicroService);
//# sourceMappingURL=micro.service.js.map