import { HttpService } from '@nestjs/axios';
import { BusinessEntity } from 'src/entity/business.entity';
import { MicroEntity } from 'src/entity/micro.entity';
import { PaginateSwaggerBusiness } from 'src/util/paginate/query-paginate';
import { Repository } from 'typeorm';
import { Intinerarie } from './dto/plan.response';
export declare class MicroService {
    private microEntity;
    private httpService;
    private businessEntity;
    private routeApiURL;
    private route;
    constructor(microEntity: Repository<MicroEntity>, httpService: HttpService, businessEntity: Repository<BusinessEntity>);
    getRouteById(id: number): Promise<{
        coordinates: number[][];
        line: string;
        name: string;
        business: {
            id: number;
            name: string;
            address: string;
            latitud: number;
            longitud: number;
            logo: string;
        }[];
    }>;
    routes(file: any, data: any): Promise<{
        line: any;
        route: string;
    }>;
    getAll(query: PaginateSwaggerBusiness): Promise<{
        data: MicroEntity[];
        total: number;
        page: number;
        totalPages: number;
    }>;
    plan(start: string, end: string): Promise<{
        data: {
            date: number;
            from: {
                name: string;
                lon: number;
                lat: number;
                vertexType: string;
            };
            to: {
                name: string;
                lon: number;
                lat: number;
                vertexType: string;
            };
            itineraries: Intinerarie[];
        };
    }>;
}
