"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.MicroController = void 0;
const common_1 = require("@nestjs/common");
const platform_express_1 = require("@nestjs/platform-express");
const micro_service_1 = require("./micro.service");
const auth_guard_1 = require("../../middleware/auth.guard");
const query_paginate_1 = require("../../util/paginate/query-paginate");
const geocode_dto_1 = require("./dto/geocode.dto");
let MicroController = class MicroController {
    constructor(microService) {
        this.microService = microService;
        this.apikey = "601fd0f4-5934-4b5d-b788-0422a2386400";
    }
    async routes(file, data) {
        return this.microService.routes(file, data);
    }
    async all(data) {
        try {
            const rows = await this.microService.getAll(data);
            return {
                statusCode: 200,
                message: ["OK"],
                ...rows
            };
        }
        catch (error) {
            console.log(error);
            throw new common_1.HttpException({
                statusCode: common_1.HttpStatus.FORBIDDEN,
                message: [error.message]
            }, common_1.HttpStatus.FORBIDDEN);
        }
    }
    async plan(params, { headers }) {
        if (headers["x-api-key"] != this.apikey)
            throw new common_1.HttpException("UnAuthorized", common_1.HttpStatus.UNAUTHORIZED);
        return this.microService.plan(params.start, params.end);
    }
    async getByID(id, { headers }) {
        return this.microService.getRouteById(id);
    }
};
exports.MicroController = MicroController;
__decorate([
    (0, common_1.Post)('routes'),
    (0, auth_guard_1.Public)(),
    (0, common_1.UseInterceptors)((0, platform_express_1.FileInterceptor)('file')),
    __param(0, (0, common_1.UploadedFile)()),
    __param(1, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Buffer, Object]),
    __metadata("design:returntype", Promise)
], MicroController.prototype, "routes", null);
__decorate([
    (0, common_1.Get)(),
    (0, auth_guard_1.Public)(),
    __param(0, (0, common_1.Query)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [query_paginate_1.PaginateSwaggerBusiness]),
    __metadata("design:returntype", Promise)
], MicroController.prototype, "all", null);
__decorate([
    (0, common_1.Get)('plan'),
    (0, auth_guard_1.Public)(),
    __param(0, (0, common_1.Query)()),
    __param(1, (0, common_1.Request)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [geocode_dto_1.GeoCode, Object]),
    __metadata("design:returntype", Promise)
], MicroController.prototype, "plan", null);
__decorate([
    (0, common_1.Get)(':id'),
    (0, auth_guard_1.Public)(),
    __param(0, (0, common_1.Param)("id")),
    __param(1, (0, common_1.Request)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Number, Object]),
    __metadata("design:returntype", Promise)
], MicroController.prototype, "getByID", null);
exports.MicroController = MicroController = __decorate([
    (0, common_1.Controller)('micro'),
    __metadata("design:paramtypes", [micro_service_1.MicroService])
], MicroController);
//# sourceMappingURL=micro.controller.js.map