export interface Step {
    distance: number;
    relativeDirection: string;
    streetName: string;
    absoluteDirection: string;
    stayOn: boolean;
    area: boolean;
    bogusName: boolean;
    lon: number;
    lat: number;
    elevation: string;
    walkingBike: boolean;
}
export interface Leg {
    startTime: number;
    endTime: number;
    departureDelay: number;
    arrivalDelay: number;
    realTime: boolean;
    distance: number;
    generalizedCost: number;
    pathway: boolean;
    mode: string;
    transitLeg: boolean;
    route: string;
    agencyTimeZoneOffset: number;
    interlineWithPreviousLeg: boolean;
    from: {
        name: string;
        lon: number;
        lat: number;
        departure: number;
        vertexType: string;
    };
    to: {
        name: string;
        lon: number;
        lat: number;
        arrival: number;
        vertexType: string;
    };
    legGeometry: {
        points: string;
        length: number;
    };
    steps: Step[];
    rentedBike: boolean;
    walkingBike: boolean;
    duration: number;
}
export interface Intinerarie {
    duration: number;
    startTime: number;
    endTime: number;
    walkTime: number;
    transitTime: number;
    waitingTime: number;
    walkDistance: number;
    walkLimitExceeded: boolean;
    generalizedCost: number;
    elevationLost: number;
    elevationGained: number;
    transfers: number;
    fare: {
        fare: {};
        details: {};
    };
    legs: Leg[];
    tooSloped: boolean;
    arrivedAtDestinationWithRentedBicycle: boolean;
}
export interface PlanResponse {
    requestParameters: {
        date: string;
        mode: string;
        arriveBy: boolean;
        wheelchair: boolean;
        showIntermediateStops: boolean;
        fromPlace: string;
        toPlace: string;
        time: string;
        locale: string;
    };
    plan: {
        date: number;
        from: {
            name: string;
            lon: number;
            lat: number;
            vertexType: string;
        };
        to: {
            name: string;
            lon: number;
            lat: number;
            vertexType: string;
        };
        itineraries: Intinerarie[];
    };
    metadata: {
        searchWindowUsed: number;
        nextDateTime: number;
        prevDateTime: number;
    };
    previousPageCursor: string;
    nextPageCursor: string;
    debugOutput: {
        precalculationTime: number;
        directStreetRouterTime: number;
        transitRouterTime: number;
        filteringTime: number;
        renderingTime: number;
        totalTime: number;
        transitRouterTimes: {
            tripPatternFilterTime: number;
            accessEgressTime: number;
            raptorSearchTime: number;
            itineraryCreationTime: number;
        };
    };
    elevationMetadata: {
        ellipsoidToGeoidDifference: number;
        geoidElevation: boolean;
    };
}
