"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.BusinessController = void 0;
const common_1 = require("@nestjs/common");
const swagger_1 = require("@nestjs/swagger");
const business_service_1 = require("./business.service");
const admin_role_1 = require("../../middleware/admin.role");
const create_business_dto_1 = require("./dto/create-business.dto");
const format_request_dto_1 = require("../../util/validator/format-request.dto");
const auth_guard_1 = require("../../middleware/auth.guard");
const query_paginate_1 = require("../../util/paginate/query-paginate");
const platform_express_1 = require("@nestjs/platform-express");
let BusinessController = class BusinessController {
    constructor(businessService) {
        this.businessService = businessService;
    }
    async create(data, { user }) {
        try {
            const rows = await this.businessService.create(data, user);
            return {
                statusCode: 200,
                message: ["Creado correctamente"],
                data: rows
            };
        }
        catch (error) {
            console.log(error);
            throw new common_1.HttpException({
                statusCode: common_1.HttpStatus.FORBIDDEN,
                message: [error.message]
            }, common_1.HttpStatus.FORBIDDEN);
        }
    }
    async createExcel(file, { user }) {
        try {
            const rows = await this.businessService.loadExcel(file, user);
            return {
                statusCode: 200,
                message: ["Creado correctamente"],
                data: rows
            };
        }
        catch (error) {
            console.log(error);
            throw new common_1.HttpException({
                statusCode: common_1.HttpStatus.FORBIDDEN,
                message: [error.message]
            }, common_1.HttpStatus.FORBIDDEN);
        }
    }
    async all(data, { user }) {
        try {
            const rows = await this.businessService.getAll(data, user);
            return {
                statusCode: 200,
                message: ["OK"],
                ...rows
            };
        }
        catch (error) {
            console.log(error);
            throw new common_1.HttpException({
                statusCode: common_1.HttpStatus.FORBIDDEN,
                message: [error.message]
            }, common_1.HttpStatus.FORBIDDEN);
        }
    }
    async allMap(data, { user }) {
        try {
            const rows = await this.businessService.getAllMap(data, user);
            return {
                statusCode: 200,
                message: ["OK"],
                ...rows
            };
        }
        catch (error) {
            console.log(error);
            throw new common_1.HttpException({
                statusCode: common_1.HttpStatus.FORBIDDEN,
                message: [error.message]
            }, common_1.HttpStatus.FORBIDDEN);
        }
    }
    async getById({ user }, id) {
        try {
            const rows = await this.businessService.getById(user, id);
            return {
                statusCode: 200,
                message: ["OK"],
                data: rows
            };
        }
        catch (error) {
            console.log(error);
            throw new common_1.HttpException({
                statusCode: common_1.HttpStatus.FORBIDDEN,
                message: [error.message]
            }, common_1.HttpStatus.FORBIDDEN);
        }
    }
};
exports.BusinessController = BusinessController;
__decorate([
    (0, common_1.Post)(),
    (0, admin_role_1.Roles)(admin_role_1.Role.ADMINISTRADOR),
    __param(0, (0, common_1.Body)()),
    __param(1, (0, common_1.Req)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [create_business_dto_1.CreateBusinessDTO, format_request_dto_1.RequestAuth]),
    __metadata("design:returntype", Promise)
], BusinessController.prototype, "create", null);
__decorate([
    (0, common_1.Post)('excel'),
    (0, common_1.UseInterceptors)((0, platform_express_1.FileInterceptor)('file')),
    (0, admin_role_1.Roles)(admin_role_1.Role.ADMINISTRADOR),
    __param(0, (0, common_1.UploadedFile)()),
    __param(1, (0, common_1.Req)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Buffer, format_request_dto_1.RequestAuth]),
    __metadata("design:returntype", Promise)
], BusinessController.prototype, "createExcel", null);
__decorate([
    (0, common_1.Get)(),
    (0, auth_guard_1.Public)(),
    __param(0, (0, common_1.Query)()),
    __param(1, (0, common_1.Req)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [query_paginate_1.PaginateSwaggerBusiness, format_request_dto_1.RequestAuth]),
    __metadata("design:returntype", Promise)
], BusinessController.prototype, "all", null);
__decorate([
    (0, common_1.Get)('map'),
    (0, auth_guard_1.Public)(),
    __param(0, (0, common_1.Query)()),
    __param(1, (0, common_1.Req)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [query_paginate_1.PaginateSwaggerBusiness, format_request_dto_1.RequestAuth]),
    __metadata("design:returntype", Promise)
], BusinessController.prototype, "allMap", null);
__decorate([
    (0, common_1.Get)('/:id'),
    (0, auth_guard_1.Public)(),
    __param(0, (0, common_1.Req)()),
    __param(1, (0, common_1.Param)("id")),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [format_request_dto_1.RequestAuth, Number]),
    __metadata("design:returntype", Promise)
], BusinessController.prototype, "getById", null);
exports.BusinessController = BusinessController = __decorate([
    (0, common_1.Controller)('business'),
    (0, swagger_1.ApiBearerAuth)("authorization"),
    (0, swagger_1.ApiTags)("business"),
    __metadata("design:paramtypes", [business_service_1.BusinessService])
], BusinessController);
//# sourceMappingURL=business.controller.js.map