"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.AppService = void 0;
const common_1 = require("@nestjs/common");
const fs_1 = require("fs");
const typeorm_1 = require("typeorm");
let AppService = class AppService {
    constructor(dataSource) {
        this.dataSource = dataSource;
    }
    async backupDatabase() {
        common_1.Logger.log(`**************************** BACKUP **************`);
        const filePath = `backup_${Date.now()}.sql`;
        const query = `COPY (SELECT * FROM usuario) TO STDOUT WITH CSV HEADER`;
        const stream = (0, fs_1.createWriteStream)(filePath);
        const queryRunner = this.dataSource.createQueryRunner();
        await queryRunner.connect();
        try {
            const resultStream = await queryRunner.connection.query(query);
            common_1.Logger.log(`**************************** res**************`);
            console.log(resultStream);
            resultStream.pipe(stream);
            return filePath;
        }
        catch (error) {
            throw new Error('Error al generar el backup: ' + error.message);
        }
        finally {
            await queryRunner.release();
        }
    }
};
exports.AppService = AppService;
exports.AppService = AppService = __decorate([
    (0, common_1.Injectable)(),
    __metadata("design:paramtypes", [typeorm_1.DataSource])
], AppService);
//# sourceMappingURL=app.service.js.map