/**
 * Allows to specify a map of Types in the object without using @Type decorator.
 * This is useful when you have external classes.
 */
export interface TargetMap {
    /**
     * Target which Types are being specified.
     */
    target: Function;
    /**
     * List of properties and their Types.
     */
    properties: {
        [key: string]: Function;
    };
}
